<?php
function jws_shortcode_courses( $atts ) {
	$is_ajax = (defined( 'DOING_AJAX' ) && DOING_AJAX);
	global $grid_columns, $pagination_type, $limit;
	$parsed_atts = shortcode_atts( array(
		'title'             => '',
		'limit'             => 6,
		'enabled_filter'    => 0,
		'enabled_thumb'     => 1,
		'grid_columns'      => 3,
		'enabled_info2' 	=> 1,
		'enabled_info' 		=> 1,
		'enabled_desc'  	=> 1,
		'enabled_meta'  	=> 1,
		'ajax_page' 		=> '',
		'orderby'			=> 'rand',
		'order'				=> 'ASC',
		'pagination_type' 	=> '',
		'img_size' 			=> '370x240',
		'archive_course_image_size' => '',
		'archive_course_layout' => '',
		'archive_course_limit_posts' => '',
	), $atts );
	wp_enqueue_script( 'magnific-popup');
	wp_enqueue_script( 'isotope');
	extract( $parsed_atts );
	$arr_col = array(
		3 => 'col-md-4 col-sm-6 col-xs-12',
		4 => 'col-md-3 col-sm-6 col-xs-12',
		5 => 'col-md-5_12 col-sm-6 col-xs-12',
		6 => 'col-md-2 col-sm-6 col-xs-12'
	);
	$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	if( $ajax_page > 1 ) $paged = $ajax_page;
	if ($archive_course_limit_posts != '') {
		$limit = $archive_course_limit_posts;
	}

	if ($archive_course_image_size != '') {
		$img_size = $archive_course_image_size;
	}
	if ($archive_course_layout != '') {
		$grid_columns = $archive_course_layout;
	}
	// global $post;
	$condition = array(
		'post_type'           => 'lp_course',
		'posts_per_page'      => $limit,
		'order'				  => $order,
		'orderby'			  => $orderby,
		'status' 			  => 'published',
		'paged' 			  => $paged,  
	);
	
	$html = '';
	$the_query = new WP_Query( $condition );
	ob_start();
	if ( $the_query->have_posts() ) :
		?>
		<div class="jws-courses-shortcode">
                    <div class="jws-courses-loader">
                        <div>
                             <div class="line"></div>
                              <div class="line"></div>
                              <div class="line"></div>
                              <div class="line"></div>
                        </div>
                   </div>
					<?php if ( $enabled_filter == 1 ): ?>
						<?php
							$cats = get_terms( 'course_category', array( 'parent' => '' ) );
							if( ! is_wp_error( $cats ) && ! empty( $cats ) ) {
								?>
								<div class="courses-filter">
									<ul class="masonry-filter list-inline text-center <?php //echo esc_attr($style_nav); ?>">
										<li><a href="#" data-filter="*" class="filter-active"><?php _e('All', 'thebrilliance'); ?></a></li>
									<?php
									foreach ($cats as $key => $cat) {
										?>
											<li><a  href="#" data-filter="<?php echo ".".esc_attr( $cat->slug ); ?>"><?php echo esc_html( $cat->name ); ?></a></li>
										<?php
									}
									?>
									</ul>
								</div>
								<?php
							}
						 ?>
					<?php endif; ?>
				<div class="row">
					<ul class="learn-press-courses jws-masonry">

						<?php
						while ( $the_query->have_posts() ) : $the_query->the_post(); 
						 	$class_slug = '';
							$item_cats  = get_the_terms( get_the_ID(), 'course_category' );
							if ( $item_cats ):
								foreach ( $item_cats as $item_cat ) {
									$class_slug .= $item_cat->slug . ' ';
								}
							endif;
							?>
							<li id="post-<?php the_ID(); ?>" class="course-item <?php echo esc_attr($arr_col[$grid_columns]); ?> <?php echo esc_attr($class_slug); ?>">
								<?php $course = LP_Global::course(); ?>
								<div class="wrap-lp-item">
									<div class="wrap-lp-thumbnail">

										<?php if (has_post_thumbnail() && $enabled_thumb == 1 ): ?> 
											<div class="lp-thumbnail">

												<?php 
									            if (function_exists('wpb_getImageBySize')) {
									            	$img = wpb_getImageBySize( array( 'attach_id' => get_post_thumbnail_id(get_the_ID()), 'thumb_size' => $img_size, 'class' => 'attachment-large wp-post-image' ) );
						                			$img = $img['thumbnail'];
										            echo wp_kses_post($img);
									            }
									            ?>
												<div class="list-action">
													<div class="wrap-list-btn">
								
														<?php
														$video_intro = get_post_meta( get_the_ID(), 'jws_course_video_intro', true );
														if ( $video_intro ) :
														?>
															<div class="button-play">
																
																<a href="<?php echo esc_url( $video_intro ); ?>" class="play-button video-thumbnail"><i class="fa fa-eye" aria-hidden="true"></i><?php esc_html_e('Watch Video','thebrilliance'); ?></a>

															</div>
														<?php 
														endif;
														?>
													</div>
												</div>
											</div>
										<?php endif; ?>

									</div>

									<div class="wrap-lp-content">

										<h2 class="lp-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
										
										<?php if ($enabled_meta == 1) : ?>
										<div class="lp-meta">
											<div class="meta-post">
								                <div class="author">
								                    <?php 
								                        $author = get_the_author_meta('ID'); 
								                        echo esc_html__('by ','thebrilliance').'<a href="'.learn_press_user_profile_link($author).'">'.get_the_author().'</a>';
								                    ?> 
								                </div>
								                <?php $arr_cat = wp_get_post_terms(get_the_ID(), 'course_category', array("fields" => "all")); ?>
								                <?php if(!empty($arr_cat)): ?>
									                <div class="categories">
									                	<?php echo esc_html__('In ','thebrilliance').get_the_term_list(get_the_ID(), 'course_category', '', ', ', ''); ?>
									                </div>
									            <?php endif; ?>
								            </div>
										</div>
										<?php endif; ?>

										<?php if ($enabled_desc == 1) : ?>
											<div class="lp-content"><?php the_excerpt(); ?></div>
											<?php 
										    $max_students = get_post_meta( get_the_ID(), '_lp_max_students', true );
										    $schedule = get_post_meta( get_the_ID(), 'jws_course_schedule', true );
										    $difficulty = get_post_meta( get_the_ID(), 'jws_course_difficulty', true );
										    $branch = get_post_meta( get_the_ID(), 'jws_course_branch', true );
										    $typology = get_post_meta( get_the_ID(), 'jws_course_typology', true );
										    $language = get_post_meta( get_the_ID(), 'jws_course_language', true ); 
										    $duration = get_post_meta( get_the_ID(), 'jws_course_duration', true ); 
										    ?>
									    <?php endif; ?>

									    <?php if ($enabled_info == 1) : ?>
											<div class="lp-info">
												<ul>
													<li>
														<span class="jws-value">
															<i class="fa fa-play-circle" aria-hidden="true"></i>
															<?php echo wp_kses_post($course->count_items()); ?>
															<?php esc_html_e('Lecture','thebrilliance'); ?>
														</span>
													</li>


													<?php if ($duration): ?>
														<li>
															<span class="jws-value">
																<i class="fa fa-clock-o" aria-hidden="true"></i> 
																<?php echo wp_kses_post($duration); ?>
															</span>
														</li>
													<?php endif; ?>
													
													<?php if ($difficulty): ?>
														<li>
															<span class="jws-value">
																<i class="fa fa-sliders" aria-hidden="true"></i>
																<?php echo wp_kses_post($difficulty); ?>
															</span>
														</li>
													<?php endif; ?>

												</ul>
											</div>
										<?php endif; ?>

										<?php if ($enabled_info2 == 1) : ?>
											<div class="course-meta">
												<?php 
												if ( $price_html = $course->get_price_html() ) { ?>
											        <span class="price"><?php echo wp_kses_post($price_html); ?></span>
												<?php
												}
												?>

												<div class="archive-lp-rating">
								                	<?php 
								                	$course_id       = $course->get_id();
													$course_rate_res = learn_press_get_course_rate( $course_id, false );
													echo "<span class='ave-rate'>".$course_rate_res['rated']."</span><span class='count-rate'>(".$course_rate_res['total'].")</span>";
													$course_rate     = $course_rate_res['rated'];
													learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate ) );
								                	?>
								                </div>

								                <div class="clearfix"></div>
											</div>
										<?php endif; ?>

									</div>
								</div>
							</li>
						<?php
						endwhile;
						?>
					</ul>
				</div>
		</div>


		<?php
	endif;
	if ( $the_query->max_num_pages > 1 && !$is_ajax && !empty( $pagination_type ) ) {

        global $pagination;
        $pagination = $pagination_type;
        jwstheme_paging_nav($the_query); 
    }

	wp_reset_postdata();
    $html .= ob_get_clean();
    ob_flush();

	if( $is_ajax ) {
        $html =  array(
            'items' => $html,
            'status' => ( $the_query->max_num_pages > $paged ) ? 'have-posts' : 'no-more-posts'
        );
    }
	return $html;
}


  if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_courses', 'jws_shortcode_courses' );
    }

if( ! function_exists( 'jws_get_course_shortcode_ajax' ) ) {
    add_action( 'wp_ajax_jws_get_course_shortcode', 'jws_get_course_shortcode_ajax' );
    add_action( 'wp_ajax_nopriv_jws_get_course_shortcode', 'jws_get_course_shortcode_ajax' );
    function jws_get_course_shortcode_ajax() {
        if( ! empty( $_POST['atts'] ) ) {
            $atts = $_POST['atts'];
            $paged = (empty($_POST['paged'])) ? 2 : (int) $_POST['paged'] + 1;
            $atts['ajax_page'] = $paged;
            $data = jws_shortcode_courses($atts);
            echo json_encode( $data );
            die();
        }
    }
}


if( ! function_exists( 'jws_get_order_course_ajax' ) ) {
    add_action( 'wp_ajax_jws_get_order_course', 'jws_get_order_course_ajax' );
    add_action( 'wp_ajax_nopriv_jws_get_order_course', 'jws_get_order_course_ajax' );
    function jws_get_order_course_ajax() {

        if( ! empty( $_POST['atts'] ) ) {
        	$attributes = $_POST['atts'];
        	$attributes['orderby'] = $_POST['orderby'];
            $data = jws_shortcode_courses($attributes);
            echo json_encode( $data );
            die();
        }
    }
}