<?php
/**
* ------------------------------------------------------------------------------------------------
* coures tabs shortcode
* ------------------------------------------------------------------------------------------------
*/

if( ! function_exists( 'thebrilliance_shortcode_coures_tabs' ) ) {
	function thebrilliance_shortcode_coures_tabs($atts = array(), $content = null) {
		if( ! function_exists( 'wpb_getImageBySize' ) ) return;
		$output = $class = $autoplay = '';
		extract(shortcode_atts( array(
			'title' => '',
			'el_class' => ''
		), $atts ));

        wp_enqueue_script( 'magnific-popup');
	    // Extract tab titles
	    preg_match_all( '/coures_tab([^\]]+)/i', $content, $matches, PREG_OFFSET_CAPTURE );
	    $tab_titles = array();

	    if ( isset( $matches[1] ) ) {
	      	$tab_titles = $matches[1];
	    }
	    $tabs_nav = '';
	    $first_tab_title = '';
	    $tabs_nav .= '<ul class="coures-tabs-title wrap-order-btn">';
	    $_i = 0;
	    foreach ( $tab_titles as $tab ) {
	    	$_i++;
			$tab_atts = shortcode_parse_atts( $tab[0] );
			$tab_atts['carousel_js_inline'] = 'yes';
			$encoded_atts = json_encode( $tab_atts );
			if( $_i == 1 && isset($tab_atts['title']) ) $first_tab_title = $tab_atts['title'];
			$class = ( $_i == 1 ) ? 'active' : '';
			if ( isset( $tab_atts['title'] ) ) {
				$tabs_nav .= '<li data-atts="' . esc_attr( $encoded_atts ) . '" class="' . esc_attr( $class ) . ' order-btn"><span class="tab-label">' . $tab_atts['title'] . '</span></li>';
			}
	    }
	    $tabs_nav .= '</ul>';

		$tabs_id = rand(999,9999);

		$class .= ' tabs-' . $tabs_id;

		$class .= ' ' . $el_class;

		ob_start(); ?>
			<div class="thebrilliance-coures-tabs jws-courses-shortcode<?php echo esc_attr( $class ); ?>">
				<div class="thebrilliance-tabs-header">
					<?php if ( ! empty( $title ) ): ?>
						<div class="tabs-name">
							<span><?php echo esc_html($title); ?></span>
						</div>
					<?php endif; ?>
					<div class="tabs-navigation-wrapper">
						<?php 
							echo wp_kses_post($tabs_nav);
						?>
					</div>
				</div>
				<?php 
					$first_tab_atts = shortcode_parse_atts( $tab_titles[0][0] );
					echo thebrilliance_shortcode_coures_tab( $first_tab_atts );
				?>
			</div>
		<?php
		$output = ob_get_contents();
		ob_end_clean();

		return $output; 
	}
    if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'coures_tabs', 'thebrilliance_shortcode_coures_tabs' );
    }

}

if( ! function_exists( 'thebrilliance_shortcode_coures_tab' ) ) {
	function thebrilliance_shortcode_coures_tab($atts) {
		global $wpdb, $post;
		if( ! function_exists( 'wpb_getImageBySize' ) ) return;
		$output = $class = '';

	    $is_ajax = (defined( 'DOING_AJAX' ) && DOING_AJAX);

		$parsed_atts = shortcode_atts( array_merge( array(
			'title' => '',
		), thebrilliance_get_default_coure_shortcode_atts()), $atts );

		extract( $parsed_atts );

		$parsed_atts['carousel_js_inline'] = 'yes';
		$parsed_atts['force_not_ajax'] = 'yes';

		ob_start(); 
             if(!$is_ajax) 
                echo '<div class="thebrilliance-coures-loader">
                    <div>
                         <div class="line"></div>
                          <div class="line"></div>
                          <div class="line"></div>
                          <div class="line"></div>
                    </div>
                </div>';
			if(!$is_ajax): ?>	
				<div class="thebrilliance-tab-content<?php echo esc_attr( $class ); ?>" > 
			<?php endif; ?>
				<?php 
					echo thebrilliance_shortcode_coures( $parsed_atts );
				 ?>
			<?php if(!$is_ajax): ?>	
				</div>
			<?php endif; ?>
		<?php
		$output = ob_get_clean();

	    if( $is_ajax ) {
	    	$output =  array(
	    		'html' => $output
	    	);
	    }
	    
	    return $output;
	}
     if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'coures_tab', 'thebrilliance_shortcode_coures_tab' );
    }

}

if( ! function_exists( 'thebrilliance_get_coures_tab_ajax' ) ) {
	add_action( 'wp_ajax_thebrilliance_get_coures_tab_shortcode', 'thebrilliance_get_coures_tab_ajax' );
	add_action( 'wp_ajax_nopriv_thebrilliance_get_coures_tab_shortcode', 'thebrilliance_get_coures_tab_ajax' );
	function thebrilliance_get_coures_tab_ajax() {
		if( ! empty( $_POST['atts'] ) ) {
			$atts = $_POST['atts'];
			$data = thebrilliance_shortcode_coures_tab($atts);
			echo json_encode( $data );
			die();
		}
	}
}

if( ! function_exists( 'thebrilliance_get_default_coure_shortcode_atts' ) ) {
	function thebrilliance_get_default_coure_shortcode_atts() {
		return array(
	        'post_type'  => 'coure',
	        'include'  => '',
	        'custom_query'  => '',
	        'taxonomies'  => '',
	        'items_per_page'  => 10,
	        'columns'  => 4,
	        'offset'  => '',
	        'orderby'  => 'date',
	        'order'  => 'DESC',
	        'meta_key'  => '',
	        'exclude'  => '',
	        'class'  => '',
	        'ajax_page' => '',
	        'img_size' => '370x240',
	        'force_not_ajax' => 'no',
	    );
	}
}


if( ! function_exists( 'thebrilliance_shortcode_coures' ) ) {
 if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'thebrilliance_coures', 'thebrilliance_shortcode_coures' );
    }
	function thebrilliance_shortcode_coures($atts, $query = false) {
		global $woocommerce_loop, $thebrilliance_loop;
	    $parsed_atts = shortcode_atts( thebrilliance_get_default_coure_shortcode_atts(), $atts );

	    extract( $parsed_atts );

		$thebrilliance_loop['img_size'] = $img_size;
   

	    $is_ajax = (defined( 'DOING_AJAX' ) && DOING_AJAX && $force_not_ajax != 'yes' );

	    $parsed_atts['force_not_ajax'] = 'no'; // :)

	    $encoded_atts = json_encode( $parsed_atts );

		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

		if( $ajax_page > 1 ) $paged = $ajax_page;

		$ordering_args = array();

         $args = array(
	    	'post_type' 			=> 'lp_course',
	    	'status' 				=> 'published',
			'ignore_sticky_posts' 	=> 1,
	    	'paged' 			  	=> $paged,	
			'orderby'             	=> $orderby,
			'order'               	=> $order,
	    	'posts_per_page' 		=> $items_per_page,
    		'meta_query'     => array(),
            'tax_query'      => array(
				'relation' => 'AND',
			),
		);


		if( $orderby == 'post__in' ) {
			$ordering_args['orderby'] = $orderby;
		}

	   

		if( ! empty( $ordering_args['meta_key'] ) ) {
			$args['meta_key'] = $ordering_args['meta_key'];
		}


		if( $post_type == 'ids' && $include != '' ) {
			$args['post__in'] = explode(',', $include);
		}

		if( ! empty( $exclude ) ) {
			$args['post__not_in'] = explode(',', $exclude);
		}

		if( ! empty( $taxonomies ) ) {
			$taxonomy_names = get_object_taxonomies( 'lp_course' );
			$terms = get_terms( $taxonomy_names, array(
				'orderby' => 'name',
				'include' => $taxonomies
			));

			if( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
				$args['tax_query'] = array('relation' => 'OR');
				foreach ($terms as $key => $term) {
					$args['tax_query'][] = array(
				        'taxonomy' => $term->taxonomy,     
				        'field' => 'slug',                  
				        'terms' => array( $term->slug ),   
				        'include_children' => true,        
				        'operator' => 'IN'  
					);
				}
			}
		}

		if( ! empty( $order ) ) {
			$args['order'] = $order;
		}

		if( ! empty( $offset ) ) {
			$args['offset'] = $offset;
		}

		$coures = new WP_Query( $args );

		// Simple coures carousel
        if($columns =="2") {
            $vccolumns = "col-md-6 col-sm-6 col-xs-12";
        }elseif($columns == "3" ) {
            $vccolumns = "col-md-4 col-sm-6 col-xs-12";
        }elseif($columns == "4" ) {
           $vccolumns = "col-md-3 col-sm-6 col-xs-12" ;
        }elseif($columns == "5" ) {
           $vccolumns = "col-md-20 col-sm-6 col-xs-12" ; 
        }elseif($columns == "6" ) {
           $vccolumns = "col-md-2 col-sm-6 col-xs-12" ; 
        }
        else {
           $vccolumns = "col-md-12 col-sm-12 col-xs-12" ; 
        }

        $class .= ' row';
     
		ob_start();
  
		if(!$is_ajax) echo '<div class="thebrilliance-coures-element">';


	    if(!$is_ajax) echo '<ul class="coures learn-press-courses  elements-grid thebrilliance-coures-holder jws-masonry ' . esc_attr( $class) . '" data-paged="1" data-count="'.$items_per_page.'" data-atts="' . esc_attr( $encoded_atts ) . '" >';
		
		if ( $coures->have_posts() ) : 

      
			while ( $coures->have_posts() ) :
			    
				$coures->the_post(); ?>
                    <li id="post-<?php the_ID(); ?>" class="course-item <?php echo esc_attr($vccolumns); ?>">
								<?php $course = LP_Global::course(); ?>
								<div class="wrap-lp-item">
									<div class="wrap-lp-thumbnail">

										<?php if (has_post_thumbnail()): ?> 
											<div class="lp-thumbnail">

												<?php 
									            if (function_exists('wpb_getImageBySize')) {
									            	$img = wpb_getImageBySize( array( 'attach_id' => get_post_thumbnail_id(get_the_ID()), 'thumb_size' => $img_size, 'class' => 'attachment-large wp-post-image' ) );
						                			$img = $img['thumbnail'];
										            echo wp_kses_post($img);
									            }
									            ?>
												<div class="list-action">
													<div class="wrap-list-btn">
								
														<?php
														$video_intro = get_post_meta( get_the_ID(), 'jws_course_video_intro', true );
														if ( $video_intro ) :
														?>
															<div class="button-play">
																
																<a href="<?php echo esc_url( $video_intro ); ?>" class="play-button video-thumbnail"><i class="fa fa-eye" aria-hidden="true"></i><?php esc_html_e('Watch Video','thebrilliance'); ?></a>

															</div>
														<?php 
														endif;
														?>
													</div>
												</div>
											</div>
										<?php endif; ?>

									</div>

									<div class="wrap-lp-content">

										<h2 class="lp-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
										
										
										<div class="lp-meta">
											<div class="meta-post">
								                <div class="author">
								                    <?php 
								                        $author = get_the_author_meta('ID'); 
								                        echo esc_html__('by ','thebrilliance').'<a href="'.learn_press_user_profile_link($author).'">'.get_the_author().'</a>';
								                    ?> 
								                </div>
								                <?php $arr_cat = wp_get_post_terms(get_the_ID(), 'course_category', array("fields" => "all")); ?>
								                <?php if(!empty($arr_cat)): ?>
									                <div class="categories">
									                	<?php echo esc_html__('In ','thebrilliance').get_the_term_list(get_the_ID(), 'course_category', '', ', ', ''); ?>
									                </div>
									            <?php endif; ?>
								            </div>
										</div>
										

										
											<div class="lp-content"><?php the_excerpt(); ?></div>
											<?php 
										    $max_students = get_post_meta( get_the_ID(), '_lp_max_students', true );
										    $schedule = get_post_meta( get_the_ID(), 'jws_course_schedule', true );
										    $difficulty = get_post_meta( get_the_ID(), 'jws_course_difficulty', true );
										    $branch = get_post_meta( get_the_ID(), 'jws_course_branch', true );
										    $typology = get_post_meta( get_the_ID(), 'jws_course_typology', true );
										    $language = get_post_meta( get_the_ID(), 'jws_course_language', true ); 
										    $duration = get_post_meta( get_the_ID(), 'jws_course_duration', true ); 
										    ?>
									   

									   
											<div class="lp-info">
												<ul>
													<li>
														<span class="jws-value">
															<i class="fa fa-play-circle" aria-hidden="true"></i>
															<?php echo wp_kses_post($course->count_items()); ?>
															<?php esc_html_e('Lecture','thebrilliance'); ?>
														</span>
													</li>


													<?php if ($duration): ?>
														<li>
															<span class="jws-value">
																<i class="fa fa-clock-o" aria-hidden="true"></i> 
																<?php echo wp_kses_post($duration); ?>
															</span>
														</li>
													<?php endif; ?>
													
													<?php if ($difficulty): ?>
														<li>
															<span class="jws-value">
																<i class="fa fa-sliders" aria-hidden="true"></i>
																<?php echo wp_kses_post($difficulty); ?>
															</span>
														</li>
													<?php endif; ?>

												</ul>
											</div>
										

										
											<div class="course-meta">
												<?php 
												if ( $price_html = $course->get_price_html() ) { ?>
											        <span class="price"><?php echo wp_kses_post($price_html); ?></span>
												<?php
												}
												?>

												<div class="archive-lp-rating">
								                	<?php 
								                	$course_id       = $course->get_id();
													$course_rate_res = learn_press_get_course_rate( $course_id, false );
													echo "<span class='ave-rate'>".$course_rate_res['rated']."</span><span class='count-rate'>(".$course_rate_res['total'].")</span>";
													$course_rate     = $course_rate_res['rated'];
													learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate ) );
								                	?>
								                </div>

								                <div class="clearfix"></div>
											</div>
									

									</div>
								</div>
							</li>
                <?php
                
			endwhile; 
       
		endif;

    	if(!$is_ajax) echo '</ul>';


		wp_reset_postdata();


    	if(!$is_ajax) echo '</div>';

		$output = ob_get_clean();

	    if( $is_ajax ) {
	    	$output =  array(
	    		'items' => $output,
	    		'status' => ( $coures->max_num_pages > $paged ) ? 'have-posts' : 'no-more-posts'
	    	);
	    }
	    
	    return $output;

	}
}