<?php
if( ! function_exists( 'jws_shortcode_portfolio' ) ) {
	
	function jws_shortcode_portfolio( $atts ) {
		global $jws_portfolio_loop, $jws_loop;
		$output = $title = $el_class = '';
	    $parsed_atts = shortcode_atts( array(
			'posts_per_page' => '',
			'filters' => '',
			'categories' => '',
			'columns' => '4',
			'spacing' => '0',
			'ajax_page' => '',
			'pagination' => ' ',
			'orderby' => 'post_date',
			'order' => 'DESC',
			'el_class' => '',
            'img_size'=>"",
            'layout' =>'grid',
            'style' => 'st1',
            'animation' => '',
            'hover_style' => 'hover1',
            'view_all_text' => 'View All',
            'view_all_link' => '#'
		), $atts );
		extract( $parsed_atts );
		wp_enqueue_script( 'isotope');
		$arr_col = array(
			2 => 'col-md-6',
			3 => 'col-md-4',
			4 => 'col-md-3',
			6 => 'col-md-2'
		);


		$encoded_atts = json_encode( $parsed_atts );
		$is_ajax = (defined( 'DOING_AJAX' ) && DOING_AJAX);
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		if( $ajax_page > 1 ) $paged = $ajax_page;
		$args = array(
			'post_type' => 'portfolio',
			'posts_per_page' => $posts_per_page,
			'orderby' => $orderby,
			'order' => $order,
			'paged' => $paged
		);
		if( get_query_var('portfolio_cat') != '' ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'portfolio_cat',
					'field'    => 'slug',
					'terms'    => get_query_var('portfolio_cat')
				),
			);
		}
		if( $categories != '' ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'portfolio_cat',
					'field'    => 'term_id',
					'operator' => 'IN',
					'terms'    => $categories
				),
			);
		}
        $style_nav = " ";
        if($style == 'st1') {
          $style_nav = ' nav_1 ';  
        }elseif($style == 'st2') {
            $style_nav = ' nav_2 ';
        }else {
            $style_nav = ' nav_3 ';
        }
        if($columns  == "4") {
            $size_pp = '3';
           }elseif($columns  == "3"){
            $size_pp = '4';
           }elseif($columns == "2"){
             $size_pp = '6';
           }else {
             $size_pp = '2';
         }    
		$jws_portfolio_loop['columns'] = $columns;
        $jws_portfolio_loop['img_size'] = $img_size;
        $jws_portfolio_loop['layout'] = $layout;
        $jws_portfolio_loop['spacing'] = $spacing;
        $class = $data = $sizer = '';
        $class = ' jws-masonry ';
       	$data  = 'data-masonry=\'{"selector":".item_portfolio   ","layoutMode":"masonryHorizontal"}\'';
       	$sizer = '<div class="grid-sizer size-'.$size_pp.'"></div>';


		
        
		$query = new WP_Query( $args );
		ob_start();
        wp_enqueue_script( 'magnific-popup');
		?>
		<?php if ( ! $is_ajax ): ?>
			<div class="<?php echo esc_attr($el_class);  ?> site-content page-portfolio" role="main">
			<?php endif ?>
				<?php if ( $query->have_posts() ) : ?>
					<?php if ( ! $is_ajax ): ?>
						<div class="wrap-portfolio-content row row-spacing-<?php echo esc_attr( $spacing ); ?>">
							<?php if ( ! is_tax() && $filters ): ?>
								<?php
									$cats = get_terms( 'portfolio_cat', array( 'parent' => $categories ) );

									if( ! is_wp_error( $cats ) && ! empty( $cats ) ) {
										?>
										<div class="portfolio-filter">
											<ul class="masonry-filter list-inline text-center <?php echo esc_attr($style_nav); ?>">
												<li><a href="#" data-filter="*" class="filter-active"><?php _e('All', 'thebrilliance'); ?></a></li>
											<?php
											foreach ($cats as $key => $cat) {
												?>
													<li><a  href="#" data-filter="<?php echo ".".esc_attr( $cat->slug ); ?>"><?php echo esc_html( $cat->name ); ?></a></li>
												<?php
											}
											?>
											</ul>
										</div>
										<?php
									}
								 ?>
							<?php endif ?>
							<div class="clearfix"></div>
							<div class="masonry-container jws-portfolio-holder <?php echo esc_attr($layout); echo esc_attr($class); echo esc_attr($el_class);?>" >
					<?php endif ?>
							<?php while ( $query->have_posts() ) : $query->the_post();

								$class_slug = '';
								$item_cats  = get_the_terms( get_the_ID(), 'portfolio_cat' );
								if ( $item_cats ):
									foreach ( $item_cats as $item_cat ) {
										$class_slug .= $item_cat->slug . ' ';
									}
								endif;
								?>
                              
                                <div class="<?php echo esc_attr($arr_col[$columns]); ?> <?php echo esc_attr($class_slug); ?>">
                                    <a href="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>">  
                                        <div class="post-thumbnail">
        								    <?php echo get_the_post_thumbnail( get_the_ID(), 'full' );  ?>
                                        </div>
                                     </a>
    							</div>
                            
							<?php endwhile; ?>
					<?php if ( ! $is_ajax ): ?>
							</div>
						</div>
						<?php
							if ( $query->max_num_pages > 1 && !$is_ajax && $pagination != 'disable' && $pagination != 'view-btn' ) {
								?>
									<div class="clearfix"></div>
							    	<div class="portfolio-footer">
							    		<?php if ( $pagination == 'more-btn'): ?>
							    			<a href="#"  class="portfolio-loadmore jws-load-more" data-atts="<?php echo esc_attr( $encoded_atts ); ?>" data-paged="<?php echo esc_attr( $paged ); ?>"><?php esc_html_e('LOAD MORE', 'thebrilliance'); ?></a>
							    			<p class="posts-loaded"><?php esc_html_e('All items Loaded.', 'thebrilliance'); ?></p>
							    		<?php endif ?>
							    	</div>
                            
                            <?php 
                        	}
						?>
					<?php endif ?>
				<?php elseif ( ! $is_ajax ) : ?>
				<?php endif; ?>
			<?php if ( ! $is_ajax ): ?>
			</div><!-- .site-content -->
			<?php endif ?>
		<?php
		$output .= ob_get_clean();

		wp_reset_postdata();
	    if( $is_ajax ) {
	    	$output =  array(
	    		'items' => $output,
	    		'status' => ( $query->max_num_pages > $paged ) ? 'have-posts' : 'no-more-posts'
	    	);
	    }
		return $output;
	}

 if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_portfolio', 'jws_shortcode_portfolio' );
    }
}


if( ! function_exists( 'jws_get_portfolio_shortcode_ajax' ) ) {
    add_action( 'wp_ajax_jws_get_portfolio_shortcode', 'jws_get_portfolio_shortcode_ajax' );
    add_action( 'wp_ajax_nopriv_jws_get_portfolio_shortcode', 'jws_get_portfolio_shortcode_ajax' );
    function jws_get_portfolio_shortcode_ajax() {
        if( ! empty( $_POST['atts'] ) ) {
            $atts = $_POST['atts'];
            $paged = (empty($_POST['paged'])) ? 2 : (int) $_POST['paged'] + 1;
            $atts['ajax_page'] = $paged;
            $data = jws_shortcode_portfolio($atts);
            echo json_encode( $data );
            die();
        }
    }
}