<?php
$post_types_list = array();
$post_types_list[] = array( 'post',esc_html__( 'Post', 'thebrilliance' ) );

/**
 * ------------------------------------------------------------------------------------------------
 * Map blog shortcode
 * ------------------------------------------------------------------------------------------------
 */
vc_map( array(
	'name' =>esc_html__( 'Blog', 'thebrilliance' ),
	'base' => 'jws_blog',
	'category' =>esc_html__( 'thebrilliance', 'thebrilliance' ),
	'description' =>esc_html__( 'Show your blog posts on the page', 'thebrilliance' ),
	'params' => array(
		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Data source', 'thebrilliance' ),
			'param_name' => 'post_type',
			'value' => $post_types_list,
			'description' =>esc_html__( 'Select content type for your grid.', 'thebrilliance' )
		),

		array(
			'type' => 'autocomplete',
			'heading' =>esc_html__( 'Include only', 'thebrilliance' ),
			'param_name' => 'include',
			'description' =>esc_html__( 'Add posts, pages, etc. by title.', 'thebrilliance' ),
			'settings' => array(
				'multiple' => true,
				'sortable' => true,
				'groups' => true,
			),
			'dependency' => array(
				'element' => 'post_type',
				'value' => array( 'ids' ),
			),
		),
		array(
			'type' => 'autocomplete',
			'heading' =>esc_html__( 'Narrow data source', 'thebrilliance' ),
			'param_name' => 'taxonomies',
			'settings' => array(
				'multiple' => true,
				// is multiple values allowed? default false
				// 'sortable' => true, // is values are sortable? default false
				'min_length' => 1,
				// min length to start search -> default 2
				// 'no_hide' => true, // In UI after select doesn't hide an select list, default false
				'groups' => true,
				// In UI show results grouped by groups, default false
				'unique_values' => true,
				// In UI show results except selected. NB! You should manually check values in backend, default false
				'display_inline' => true,
				// In UI show results inline view, default false (each value in own line)
				'delay' => 500,
				// delay for search. default 500
				'auto_focus' => true,
				// auto focus input, default true
				// 'values' => $taxonomies_for_filter,
			),
			'param_holder_class' => 'vc_not-for-custom',
			'description' =>esc_html__( 'Enter categories, tags or custom taxonomies.', 'thebrilliance' ),
			'dependency' => array(
				'element' => 'post_type',
				'value_not_equal_to' => array( 'ids', 'custom' ),
			),
		),

		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Title Block', 'thebrilliance' ),
			'param_name' => 'title_block',
			// 'description' =>esc_html__( 'Number of items to show per page.', 'thebrilliance' ),
			// 'value' => '4',
		),

		array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Length Excerpt', 'thebrilliance' ),
            'param_name' => 'length_excerpt',
            'description' =>esc_html__( 'Input Length Excerpt Number', 'thebrilliance' ),
            'value' => '16',
        ),
        
        array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Text Read More', 'thebrilliance' ),
			'param_name' => 'readmore_text',
			'description' =>esc_html__( 'Add Text For Read More blog', 'thebrilliance' ),
			'value' => 'READ MORE',
		),
		array(
            'type' => 'checkbox',
            'heading' =>esc_html__('Hide Meta', 'thebrilliance'),
            'param_name' => 'hide_meta',
            'value' => array(
               esc_html__('Yes, please', 'thebrilliance') => true
            ),
            'description' =>esc_html__('Show or hide Meta.', 'thebrilliance')
        ),
		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Items per page', 'thebrilliance' ),
			'param_name' => 'items_per_page',
			'description' =>esc_html__( 'Number of items to show per page.', 'thebrilliance' ),
			'value' => '4',
		),
		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Pagination', 'thebrilliance' ),
			'param_name' => 'pagination_type',
			'value' => array(
                '' => '', 
                'Numeric' => 'numeric', 
                'Load more' => 'loadmore', 
			),
		),
		// Design settings
		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Style', 'thebrilliance' ),
			'param_name' => 'blog_design',
			'value' => array(
               esc_html__( 'Default', 'thebrilliance' ) => 'default', 
               esc_html__( 'Style 1', 'thebrilliance' ) => 'style-1', 
			),
			'description' =>esc_html__( 'You can use different design for your blog styled for the theme', 'thebrilliance' ),
			'group' =>esc_html__( 'Design', 'thebrilliance' ),
		),
        // Design settings
		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Images size', 'thebrilliance' ),
			'group' =>esc_html__( 'Design', 'thebrilliance' ),
			'param_name' => 'img_size',
			'description' =>esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'thebrilliance' )
		),
		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Columns', 'thebrilliance' ),
			'param_name' => 'blog_columns',
			 "value" => array(
                   esc_html__( '4 columns', 'thebrilliance' ) => "4",
                   esc_html__( '3 columns', 'thebrilliance' ) => "3",
                   esc_html__( '2 columns', 'thebrilliance' ) => "2",
                   esc_html__( '1 column', 'thebrilliance' ) => "1"
                ),
			'description' =>esc_html__( 'Blog items columns', 'thebrilliance' ),
			'group' =>esc_html__( 'Design', 'thebrilliance' ),
            'std'   =>  '2',
		),
		// Data settings
		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Order by', 'thebrilliance' ),
			'param_name' => 'orderby',
			'value' => array(
				__( 'Date', 'thebrilliance' ) => 'date',
				__( 'Order by post ID', 'thebrilliance' ) => 'ID',
				__( 'Author', 'thebrilliance' ) => 'author',
				__( 'Title', 'thebrilliance' ) => 'title',
				__( 'Last modified date', 'thebrilliance' ) => 'modified',
				__( 'Post/page parent ID', 'thebrilliance' ) => 'parent',
				__( 'Number of comments', 'thebrilliance' ) => 'comment_count',
				__( 'Menu order/Page Order', 'thebrilliance' ) => 'menu_order',
				__( 'Meta value', 'thebrilliance' ) => 'meta_value',
				__( 'Meta value number', 'thebrilliance' ) => 'meta_value_num',
				__( 'Random order', 'thebrilliance' ) => 'rand',
			),
			'description' =>esc_html__( 'Select order type. If "Meta value" or "Meta value Number" is chosen then meta key is required.', 'thebrilliance' ),
			'group' =>esc_html__( 'Data Settings', 'thebrilliance' ),
			'param_holder_class' => 'vc_grid-data-type-not-ids',
			'dependency' => array(
				'element' => 'post_type',
				'value_not_equal_to' => array( 'ids', 'custom' ),
			),
		),
		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Sorting', 'thebrilliance' ),
			'param_name' => 'order',
			'group' =>esc_html__( 'Data Settings', 'thebrilliance' ),
			'value' => array(
				__( 'Descending', 'thebrilliance' ) => 'DESC',
				__( 'Ascending', 'thebrilliance' ) => 'ASC',
			),
			'param_holder_class' => 'vc_grid-data-type-not-ids',
			'description' =>esc_html__( 'Select sorting order.', 'thebrilliance' ),
			'dependency' => array(
				'element' => 'post_type',
				'value_not_equal_to' => array( 'ids', 'custom' ),
			),
		),
		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Meta key', 'thebrilliance' ),
			'param_name' => 'meta_key',
			'description' =>esc_html__( 'Input meta key for grid ordering.', 'thebrilliance' ),
			'group' =>esc_html__( 'Data Settings', 'thebrilliance' ),
			'param_holder_class' => 'vc_grid-data-type-not-ids',
			'dependency' => array(
				'element' => 'orderby',
				'value' => array( 'meta_value', 'meta_value_num' ),
			),
		),
		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Offset', 'thebrilliance' ),
			'param_name' => 'offset',
			'description' =>esc_html__( 'Number of grid elements to displace or pass over.', 'thebrilliance' ),
			'group' =>esc_html__( 'Data Settings', 'thebrilliance' ),
			'param_holder_class' => 'vc_grid-data-type-not-ids',
			'dependency' => array(
				'element' => 'post_type',
				'value_not_equal_to' => array( 'ids', 'custom' ),
			),
		),
		array(
			'type' => 'autocomplete',
			'heading' =>esc_html__( 'Exclude', 'thebrilliance' ),
			'param_name' => 'exclude',
			'description' =>esc_html__( 'Exclude posts, pages, etc. by title.', 'thebrilliance' ),
			'group' =>esc_html__( 'Data Settings', 'thebrilliance' ),
			'settings' => array(
				'multiple' => true,
			),
			'param_holder_class' => 'vc_grid-data-type-not-ids',
			'dependency' => array(
				'element' => 'post_type',
				'value_not_equal_to' => array( 'ids', 'custom' ),
				'callback' => 'vc_grid_exclude_dependency_callback',
			),
		)
    )
) );

// Necessary hooks for jws_blog autocomplete fields
add_filter( 'vc_autocomplete_jws_blog_include_callback', 'vc_include_field_search', 10, 1 ); // Get suggestion(find). Must return an array
add_filter( 'vc_autocomplete_jws_blog_include_render',
    'vc_include_field_render', 10, 1 ); // Render exact product. Must return an array (label,value)

// Narrow data taxonomies
add_filter( 'vc_autocomplete_jws_blog_taxonomies_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
add_filter( 'vc_autocomplete_jws_blog_taxonomies_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

// Narrow data taxonomies for exclude_filter
add_filter( 'vc_autocomplete_jws_blog_exclude_filter_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
add_filter( 'vc_autocomplete_jws_blog_exclude_filter_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

add_filter( 'vc_autocomplete_jws_blog_exclude_callback', 'vc_exclude_field_search', 10, 1 ); // Get suggestion(find). Must return an array
add_filter( 'vc_autocomplete_jws_blog_exclude_render', 'vc_exclude_field_render', 10, 1 ); // Render exact product. Must return an array (label,value)