<?php
vc_map(array(
    'name' =>esc_html__( 'Event Shortcode', 'thebrilliance' ),
    'base' => 'jws_event_shortcode',
    'class' => '',
    'category' =>esc_html__( 'thebrilliance', 'thebrilliance' ),
    'params' => array(

        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Layout', 'thebrilliance' ),
            'param_name' => 'layout',
            'value' => array(
               esc_html__( 'Grid', 'thebrilliance' ) => 'grid',
               esc_html__( 'List', 'thebrilliance' ) => 'list-style',
               esc_html__( 'List Slide', 'thebrilliance' ) => 'list-slide',
               esc_html__( 'Single', 'thebrilliance' ) => 'single',
            ),  
            'std' => 'list-slide',
        ),

        array(
            'type' => 'autocomplete',
            'heading' =>esc_html__( 'Include only', 'thebrilliance' ),
            'param_name' => 'include',
            'description' =>esc_html__( 'Add event by title.', 'thebrilliance' ),
            'settings' => array(
                'multiple' => false,
                'sortable' => true,
                'groups' => true,
            ),
        ),

        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Items per page', 'thebrilliance' ),
            'param_name' => 'items_per_page',
            'description' =>esc_html__( 'Number of items to show per page.', 'thebrilliance' ),
            'value' => '5',
            'dependency' => array(
                'element' => 'layout',
                'value' => array( 'list-slide','list-style' ),
            ),
        ),

        array(
            "type" => "checkbox",
            "heading" =>esc_html__('Show Countdown', "thebrilliance"),
            "param_name" => "show_countdown",
            "value" => array(
               esc_html__("Yes, please", "thebrilliance") => 'yes'
            ),
            'dependency' => array(
                'element' => 'layout',
                'value' => array( 'single' ),
            ),
            'std' => 'no',
        ),

        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Image size', 'thebrilliance' ),
            'param_name' => 'img_size',
            'description' =>esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'thebrilliance' ),
            'value' => 'thumbnail',
            'dependency' => array(
                'element' => 'layout',
                'value' => array( 'single' ),
            ),
        ),
        

        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Extra class name', 'thebrilliance' ),
            'param_name' => 'el_class',
            'description' =>esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'thebrilliance' )
        )
    )
));


// Necessary hooks for jws_event_shortcode autocomplete fields
add_filter( 'vc_autocomplete_jws_event_shortcode_include_callback', 'vc_include_field_search', 10, 1 ); // Get suggestion(find). Must return an array
add_filter( 'vc_autocomplete_jws_event_shortcode_include_render',
    'vc_include_field_render', 10, 1 ); // Render exact product. Must return an array (label,value)

// Narrow data taxonomies
add_filter( 'vc_autocomplete_jws_event_shortcode_taxonomies_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
add_filter( 'vc_autocomplete_jws_event_shortcode_taxonomies_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

// Narrow data taxonomies for exclude_filter
add_filter( 'vc_autocomplete_jws_event_shortcode_exclude_filter_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
add_filter( 'vc_autocomplete_jws_event_shortcode_exclude_filter_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

add_filter( 'vc_autocomplete_jws_event_shortcode_exclude_callback', 'vc_exclude_field_search', 10, 1 ); // Get suggestion(find). Must return an array
add_filter( 'vc_autocomplete_jws_event_shortcode_exclude_render', 'vc_exclude_field_render', 10, 1 ); // Render exact product. Must return an array (label,value)