<?php
// Map Google Map
vc_map(array(
    "name" =>esc_html__('Google Maps V3', 'thebrilliance'),
    "base" => "maps",
    "category" =>esc_html__('thebrilliance', 'thebrilliance'),
    "icon" => "jws-icon-for-vc",
    "description" =>esc_html__('Google Maps API V3', 'thebrilliance'),
    "params" => array(
        array(
            "type" => "textfield",
            "heading" =>esc_html__('API Key', 'thebrilliance'),
            "param_name" => "api",
            "value" => '',
            "description" =>esc_html__('Enter you api key of map, get key from (https://console.developers.google.com)', 'thebrilliance')
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__('Address', 'thebrilliance'),
            "param_name" => "address",
            "value" => 'New York, United States',
            "description" =>esc_html__('Enter address of Map', 'thebrilliance')
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__('Coordinate', 'thebrilliance'),
            "param_name" => "coordinate",
            "value" => '',
            "description" =>esc_html__('Enter coordinate of Map, format input (latitude, longitude)', 'thebrilliance')
        ),
        array(
            "type" => "checkbox",
            "heading" =>esc_html__('Click Show Info window', 'thebrilliance'),
            "param_name" => "infoclick",
            "value" => array(
               esc_html__("Yes, please", 'thebrilliance') => true
            ),
            "group" =>esc_html__("Marker", 'thebrilliance'),
            "description" =>esc_html__('Click a marker and show info window (Default Show).', 'thebrilliance')
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__('Marker Coordinate', 'thebrilliance'),
            "param_name" => "markercoordinate",
            "value" => '',
            "group" =>esc_html__("Marker", 'thebrilliance'),
            "description" =>esc_html__('Enter marker coordinate of Map, format input (latitude, longitude)', 'thebrilliance')
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__('Marker Title', 'thebrilliance'),
            "param_name" => "markertitle",
            "value" => '',
            "group" =>esc_html__("Marker", 'thebrilliance'),
            "description" =>esc_html__('Enter Title Info windows for marker', 'thebrilliance')
        ),
        array(
            "type" => "textarea",
            "heading" =>esc_html__('Marker Description', 'thebrilliance'),
            "param_name" => "markerdesc",
            "value" => '',
            "group" =>esc_html__("Marker", 'thebrilliance'),
            "description" =>esc_html__('Enter Description Info windows for marker', 'thebrilliance')
        ),
        array(
            "type" => "attach_image",
            "heading" =>esc_html__('Marker Icon', 'thebrilliance'),
            "param_name" => "markericon",
            "value" => '',
            "group" =>esc_html__("Marker", 'thebrilliance'),
            "description" =>esc_html__('Select image icon for marker', 'thebrilliance')
        ),
        array(
            "type" => "textarea_raw_html",
            "heading" =>esc_html__('Marker List', 'thebrilliance'),
            "param_name" => "markerlist",
            "value" => '',
            "group" =>esc_html__("Multiple Marker", 'thebrilliance'),
            "description" =>esc_html__('[{"coordinate":"41.058846,-73.539423","icon":"","title":"title demo 1","desc":"desc demo 1"},{"coordinate":"40.975699,-73.717636","icon":"","title":"title demo 2","desc":"desc demo 2"},{"coordinate":"41.082606,-73.469718","icon":"","title":"title demo 3","desc":"desc demo 3"}]', 'thebrilliance')
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__('Info Window Max Width', 'thebrilliance'),
            "param_name" => "infowidth",
            "value" => '300',
            "group" =>esc_html__("Marker", 'thebrilliance'),
            "description" =>esc_html__('Set max width for info window', 'thebrilliance')
        ),
        array(
            "type" => "dropdown",
            "heading" =>esc_html__("Map Type", 'thebrilliance'),
            "param_name" => "type",
            "value" => array(
                "ROADMAP" => "ROADMAP",
                "HYBRID" => "HYBRID",
                "SATELLITE" => "SATELLITE",
                "TERRAIN" => "TERRAIN"
            ),
            "description" =>esc_html__('Select the map type.', 'thebrilliance')
        ),
        array(
            "type" => "dropdown",
            "heading" =>esc_html__("Style Template", 'thebrilliance'),
            "param_name" => "style",
            "value" => array(
                "Default" => "",
                "Subtle Grayscale" => "Subtle-Grayscale",
                "Shades of Grey" => "Shades-of-Grey",
                "Blue water" => "Blue-water",
                "Pale Dawn" => "Pale-Dawn",
                "Blue Essence" => "Blue-Essence",
                "Apple Maps-esque" => "Apple-Maps-esque",
            ),
            "group" =>esc_html__("Map Style", 'thebrilliance'),
            "description" => 'Select your heading size for title.'
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__('Zoom', 'thebrilliance'),
            "param_name" => "zoom",
            "value" => '15',
            "description" =>esc_html__('zoom level of map, default is 15', 'thebrilliance')
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__('Width', 'thebrilliance'),
            "param_name" => "width",
            "value" => 'auto',
            "description" =>esc_html__('Width of map without pixel, default is auto', 'thebrilliance')
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__('Height', 'thebrilliance'),
            "param_name" => "height",
            "value" => '350px',
            "description" =>esc_html__('Height of map without pixel, default is 350px', 'thebrilliance')
        ),
        array(
            "type" => "checkbox",
            "heading" =>esc_html__('Scroll Wheel', 'thebrilliance'),
            "param_name" => "scrollwheel",
            "value" => array(
               esc_html__("Yes, please", 'thebrilliance') => true
            ),
            "group" =>esc_html__("Controls", 'thebrilliance'),
            "description" =>esc_html__('If false, disables scrollwheel zooming on the map. The scrollwheel is disable by default.', 'thebrilliance')
        ),
        array(
            "type" => "checkbox",
            "heading" =>esc_html__('Pan Control', 'thebrilliance'),
            "param_name" => "pancontrol",
            "value" => array(
               esc_html__("Yes, please", 'thebrilliance') => true
            ),
            "group" =>esc_html__("Controls", 'thebrilliance'),
            "description" =>esc_html__('Show or hide Pan control.', 'thebrilliance')
        ),
        array(
            "type" => "checkbox",
            "heading" =>esc_html__('Zoom Control', 'thebrilliance'),
            "param_name" => "zoomcontrol",
            "value" => array(
               esc_html__("Yes, please", 'thebrilliance') => true
            ),
            "group" =>esc_html__("Controls", 'thebrilliance'),
            "description" =>esc_html__('Show or hide Zoom Control.', 'thebrilliance')
        ),
        array(
            "type" => "checkbox",
            "heading" =>esc_html__('Scale Control', 'thebrilliance'),
            "param_name" => "scalecontrol",
            "value" => array(
               esc_html__("Yes, please", 'thebrilliance') => true
            ),
            "group" =>esc_html__("Controls", 'thebrilliance'),
            "description" =>esc_html__('Show or hide Scale Control.', 'thebrilliance')
        ),
        array(
            "type" => "checkbox",
            "heading" =>esc_html__('Map Type Control', 'thebrilliance'),
            "param_name" => "maptypecontrol",
            "value" => array(
               esc_html__("Yes, please", 'thebrilliance') => true
            ),
            "group" =>esc_html__("Controls", 'thebrilliance'),
            "description" =>esc_html__('Show or hide Map Type Control.', 'thebrilliance')
        ),
        array(
            "type" => "checkbox",
            "heading" =>esc_html__('Street View Control', 'thebrilliance'),
            "param_name" => "streetviewcontrol",
            "value" => array(
               esc_html__("Yes, please", 'thebrilliance') => true
            ),
            "group" =>esc_html__("Controls", 'thebrilliance'),
            "description" =>esc_html__('Show or hide Street View Control.', 'thebrilliance')
        ),
        array(
            "type" => "checkbox",
            "heading" =>esc_html__('Over View Map Control', 'thebrilliance'),
            "param_name" => "overviewmapcontrol",
            "value" => array(
               esc_html__("Yes, please", 'thebrilliance') => true
            ),
            "group" =>esc_html__("Controls", 'thebrilliance'),
            "description" =>esc_html__('Show or hide Over View Map Control.', 'thebrilliance')
        )
    )
));