<?php
// information box
vc_map(array(
    'name' =>esc_html__( 'Information box', 'thebrilliance' ),
    'base' => 'jws_info_box',
    'class' => '',
    'category' =>esc_html__( 'thebrilliance', 'thebrilliance' ),
    'description' =>esc_html__( 'Show some brief information', 'thebrilliance' ),
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Thumbnail Type', 'thebrilliance' ),
            'param_name' => 'thumb_type',
            'value' => array(
               esc_html__( 'Image', 'thebrilliance' ) => 'image',
            ),
            'std' => 'image',
        ),

        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Icon', 'thebrilliance' ),
            'param_name' => 'icon',
            'value' => '',
            'description' =>esc_html__( 'Add Class icon from <a href="http://docteur-abrar.com/wp-content/themes/thunder/admin/stroke-gap-icons/" >Link</a>. Example: Time  ', 'thebrilliance' ),
            'dependency' => array(
                'element' => 'thumb_type',
                'value' => 'icon',
            ),
        ),

        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Icon font-size', 'thebrilliance' ),
            'param_name' => 'icon_size',
            'description' =>esc_html__( 'Enter icon font size. Example: 50', 'thebrilliance' ),
            'value' => '50',
            'dependency' => array(
                'element' => 'thumb_type',
                'value' => 'icon',
            ),
        ),

        array(
            'type' => 'colorpicker',
            'heading' =>esc_html__( 'Icon color', 'thebrilliance' ),
            'param_name' => 'icon_color',
            'description' =>esc_html__( 'Select icon color.', 'thebrilliance' ),
            'value' => '#e62739',
            'dependency' => array(
                'element' => 'thumb_type',
                'value' => 'icon',
            ),
        ),

        array(
            'type' => 'attach_image',
            'heading' =>esc_html__( 'Image', 'thebrilliance' ),
            'param_name' => 'image',
            'value' => '',
            'description' =>esc_html__( 'Select image from media library.', 'thebrilliance' ),
            'dependency' => array(
                'element' => 'thumb_type',
                'value' => 'image',
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Image size', 'thebrilliance' ),
            'param_name' => 'img_size',
            'description' =>esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'thebrilliance' ),
            'value' => 'thumbnail',
            'dependency' => array(
                'element' => 'thumb_type',
                'value' => 'image',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' =>esc_html__( 'Background gradient 1', 'thebrilliance' ),
            'param_name' => 'g1',
            'description' =>esc_html__( 'Select color.', 'thebrilliance' ),
            'value' => '#27c7a0',
        ),
        array(
            'type' => 'colorpicker',
            'heading' =>esc_html__( 'Background gradient 2', 'thebrilliance' ),
            'param_name' => 'g2',
            'description' =>esc_html__( 'Select color.', 'thebrilliance' ),
            'value' => '#7ed93e',
        ),

        array(
            'type' => 'href',
            'heading' =>esc_html__( 'Link', 'thebrilliance'),
            'param_name' => 'link',
            'description' =>esc_html__( 'Enter URL if you want this box to have a link.', 'thebrilliance' )
        ),
        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Title', 'thebrilliance' ),
            'param_name' => 'info_title',
            'value' => 'More than an education',
        ),
        array(
            'type' => 'textarea_html',
            'holder' => 'div',
            'heading' =>esc_html__( 'Content', 'thebrilliance' ),
            'param_name' => 'content',
            'value' => 'The lysine contingency it\'s intended to prevent the spread of the animals is case they ever got off the island. Dr. Wueszef inserted a gene that makes a single faulty enzyme.',
        ),
        array(
            'type' => 'colorpicker',
            'heading' =>esc_html__( 'Text Color', 'thebrilliance' ),
            'param_name' => 'text_color',
            'description' =>esc_html__( 'Select color.', 'thebrilliance' ),
            'value' => '#fff',
        ),
        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Text alignment', 'thebrilliance' ),
            'param_name' => 'alignment',
            'value' => array(
               esc_html__( 'Align center', 'thebrilliance' ) => 'al-center',
               esc_html__( 'Align left', 'thebrilliance' ) => 'al-left',
               esc_html__( 'Align right', 'thebrilliance' ) => 'al-right'
            ),
            'std' => 'al-left',
        ),
        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Thumbnail position', 'thebrilliance' ),
            'param_name' => 'thumb_position',
            'value' => array(
               esc_html__( 'Top', 'thebrilliance' ) => 'top',  
               esc_html__( 'Inline-Left', 'thebrilliance' ) => 'inline-left',
            ),
            'std' => 'inline-left',
        ),
        array(
            'type' => 'css_editor',
            'heading' =>esc_html__( 'CSS box', 'thebrilliance' ),
            'param_name' => 'css',
            'group' =>esc_html__( 'Design Options', 'thebrilliance' )
        ),
        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Extra class name', 'thebrilliance' ),
            'param_name' => 'el_class',
            'description' =>esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'thebrilliance' )
        )
    )
));
