<?php 
if( ! function_exists( 'thebrilliance_get_coures_shortcode_params' ) ) {
        	function thebrilliance_get_coures_shortcode_map_params() {
        		return array(
        			'name' => esc_html__( 'coures (grid or carousel)', 'thebrilliance' ),
        			'base' => 'thebrilliance_coures',
        			'class' => '',
        			'category' => esc_html__( 'thebrilliance', 'thebrilliance' ),
        			'description' => esc_html__( 'Animated carousel with posts', 'thebrilliance' ),
        			'params' => thebrilliance_get_coures_shortcode_params() 
        		);
         	}
        }

if( ! function_exists( 'thebrilliance_get_coures_shortcode_params' ) ) {
	function thebrilliance_get_coures_shortcode_params() {
		return apply_filters( 'thebrilliance_get_coures_shortcode_params', array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Data source', 'thebrilliance' ),
					'param_name' => 'post_type',
					'value' =>  array(
						array( 'coure', esc_html__( 'All coures', 'thebrilliance' ) ),
						array( 'ids', esc_html__( 'List of IDs', 'thebrilliance' ) )

					),
					'description' => esc_html__( 'Select content type for your grid.', 'thebrilliance' )
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Include only', 'thebrilliance' ),
					'param_name' => 'include',
					'description' => esc_html__( 'Add coures by title.', 'thebrilliance' ),
					'settings' => array(
						'multiple' => true,
						'sortable' => true,
						'groups' => true,
					),
					'dependency' => array(
						'element' => 'post_type',
						'value' => array( 'ids' ),
						//'callback' => 'vc_grid_include_dependency_callback',
					),
				),
				// Custom query tab
				array(
					'type' => 'textarea_safe',
					'heading' => esc_html__( 'Custom query', 'thebrilliance' ),
					'param_name' => 'custom_query',
					'description' => esc_html__( 'Build custom query according to <a href="http://codex.wordpress.org/Function_Reference/query_posts">WordPress Codex</a>.', 'thebrilliance' ),
					'dependency' => array(
						'element' => 'post_type',
						'value' => array( 'custom' ),
					),
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Categories or tags', 'thebrilliance' ),
					'param_name' => 'taxonomies',
					'settings' => array(
						'multiple' => true,
						// is multiple values allowed? default false
						// 'sortable' => true, // is values are sortable? default false
						'min_length' => 1,
						// min length to start search -> default 2
						// 'no_hide' => true, // In UI after select doesn't hide an select list, default false
						'groups' => true,
						// In UI show results grouped by groups, default false
						'unique_values' => true,
						// In UI show results except selected. NB! You should manually check values in backend, default false
						'display_inline' => true,
						// In UI show results inline view, default false (each value in own line)
						'delay' => 500,
						// delay for search. default 500
						'auto_focus' => true,
						// auto focus input, default true
					),
					'param_holder_class' => 'vc_not-for-custom',
					'description' => esc_html__( 'Enter categories, tags or custom taxonomies.', 'thebrilliance' ),
					'dependency' => array(
						'element' => 'post_type',
						'value_not_equal_to' => array( 'ids', 'custom' ),
					),
				),
				array(
                    'type' => 'textfield',
					'heading' => esc_html__( 'Items per page', 'thebrilliance' ),
					'param_name' => 'items_per_page',
					'description' => esc_html__( 'Number of items to show per page.', 'thebrilliance' ),
					'value' => '10',
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Columns', 'thebrilliance' ),
					'param_name' => 'columns',
					'value' => array(
						1,2, 3, 4, 5 , 6
					),
					'description' => esc_html__( 'Columns', 'thebrilliance' ),
					'group' => esc_html__( 'Design', 'thebrilliance' ),
				),
                array(
        			'type' => 'textfield',
        			'heading' =>esc_html__( 'Images size', 'thebrilliance' ),
        			'group' =>esc_html__( 'Design', 'thebrilliance' ),
        			'param_name' => 'img_size',
        			'description' =>esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'thebrilliance' ),
        		    'group' => esc_html__( 'Design', 'thebrilliance' ),  
                ),
				// Data settings
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Order by', 'thebrilliance' ),
					'param_name' => 'orderby',
					'value' => array(
						__( 'Date', 'thebrilliance' ) => 'date',
						__( 'Order by post ID', 'thebrilliance' ) => 'ID',
						__( 'Author', 'thebrilliance' ) => 'author',
						__( 'Title', 'thebrilliance' ) => 'title',
						__( 'Last modified date', 'thebrilliance' ) => 'modified',
						__( 'Number of comments', 'thebrilliance' ) => 'comment_count',
						__( 'Menu order/Page Order', 'thebrilliance' ) => 'menu_order',
						__( 'Meta value', 'thebrilliance' ) => 'meta_value',
						__( 'Meta value number', 'thebrilliance' ) => 'meta_value_num',
						__( 'Matches same order you passed in via the include parameter.', 'thebrilliance') => 'post__in',
						__( 'Random order', 'thebrilliance' ) => 'rand',
						__( 'Price', 'thebrilliance' ) => 'price',
					),
					'description' => esc_html__( 'Select order type. If "Meta value" or "Meta value Number" is chosen then meta key is required.', 'thebrilliance' ),
					'group' => esc_html__( 'Data Settings', 'thebrilliance' ),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'dependency' => array(
						'element' => 'post_type',
						'value_not_equal_to' => array( 'custom' ),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Sorting', 'thebrilliance' ),
					'param_name' => 'order',
					'group' => esc_html__( 'Data Settings', 'thebrilliance' ),
					'value' => array(
						__( 'Descending', 'thebrilliance' ) => 'DESC',
						__( 'Ascending', 'thebrilliance' ) => 'ASC',
					),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'description' => esc_html__( 'Select sorting order.', 'thebrilliance' ),
					'dependency' => array(
						'element' => 'post_type',
						'value_not_equal_to' => array( 'ids', 'custom' ),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Meta key', 'thebrilliance' ),
					'param_name' => 'meta_key',
					'description' => esc_html__( 'Input meta key for grid ordering.', 'thebrilliance' ),
					'group' => esc_html__( 'Data Settings', 'thebrilliance' ),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'dependency' => array(
						'element' => 'orderby',
						'value' => array( 'meta_value', 'meta_value_num' ),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Offset', 'thebrilliance' ),
					'param_name' => 'offset',
					'description' => esc_html__( 'Number of grid elements to displace or pass over.', 'thebrilliance' ),
					'group' => esc_html__( 'Data Settings', 'thebrilliance' ),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'dependency' => array(
						'element' => 'post_type',
						'value_not_equal_to' => array( 'ids', 'custom' ),
					),
				),
				array(
					'type' => 'autocomplete',
					'heading' => esc_html__( 'Exclude', 'thebrilliance' ),
					'param_name' => 'exclude',
					'description' => esc_html__( 'Exclude posts, pages, etc. by title.', 'thebrilliance' ),
					'group' => esc_html__( 'Data Settings', 'thebrilliance' ),
					'settings' => array(
						'multiple' => true,
					),
					'param_holder_class' => 'vc_grid-data-type-not-ids',
					'dependency' => array(
						'element' => 'post_type',
						'value_not_equal_to' => array( 'ids', 'custom' ),
						'callback' => 'vc_grid_exclude_dependency_callback',
					),
				),

			)
		);
	}
}

		// Necessary hooks for blog autocomplete fields
		add_filter( 'vc_autocomplete_thebrilliance_coures_include_callback',	'vc_include_field_search', 10, 1 ); // Get suggestion(find). Must return an array
		add_filter( 'vc_autocomplete_thebrilliance_coures_include_render',
			'vc_include_field_render', 10, 1 ); // Render exact coure. Must return an array (label,value)

		// Narrow data taxonomies
		add_filter( 'vc_autocomplete_thebrilliance_coures_taxonomies_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
		add_filter( 'vc_autocomplete_thebrilliance_coures_taxonomies_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

		// Narrow data taxonomies for exclude_filter
		add_filter( 'vc_autocomplete_thebrilliance_coures_exclude_filter_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
		add_filter( 'vc_autocomplete_thebrilliance_coures_exclude_filter_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

		add_filter( 'vc_autocomplete_thebrilliance_coures_exclude_callback',	'vc_exclude_field_search', 10, 1 ); // Get suggestion(find). Must return an array
		add_filter( 'vc_autocomplete_thebrilliance_coures_exclude_render', 'vc_exclude_field_render', 10, 1 ); // Render exact coure. Must return an array (label,value)
        
		/**
		 * ------------------------------------------------------------------------------------------------
		 * Map coures tabs shortcode
		 * ------------------------------------------------------------------------------------------------
		 */
		vc_map( array(
			'name' => __( 'AJAX coures tabs', 'thebrilliance' ),
			'base' => 'coures_tabs',
            "as_parent" => array('only' => 'coures_tab'),
			"content_element" => true,
			"show_settings_on_create" => true,
			'category' => __( 'thebrilliance', 'thebrilliance' ),
			'description' => __( 'coure tabs for your marketplace', 'thebrilliance' ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => __( 'Title', 'thebrilliance' ),
					'param_name' => 'title',
				),
				array(
					'type' => 'textfield',
					'heading' => __( 'Extra class name', 'thebrilliance' ),
					'param_name' => 'el_class',
					'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'thebrilliance' )
				)
			),
		    "js_view" => 'VcColumnView'
		));
 	    $thebrilliance_prdoucts_params = vc_map_integrate_shortcode( thebrilliance_get_coures_shortcode_map_params(), '', '', array(
			'exclude' => array(
			),
		));

		vc_map( array(
			'name' => __( 'coures tab', 'thebrilliance' ),
			'base' => 'coures_tab',
			'class' => '',
			"as_child" => array('only' => 'coures_tabÑ–'),
			"content_element" => true,
			'category' => __( 'thebrilliance', 'thebrilliance' ),
			'description' => __( 'coures block', 'thebrilliance' ),
			'params' => array_merge( array(
				array(
					'type' => 'textfield',
					'heading' => __( 'Title for the tab', 'thebrilliance' ),
					'param_name' => 'title',
					'value' => '',
				)
			), $thebrilliance_prdoucts_params )
		));
 	     // Necessary hooks for blog autocomplete fields
		add_filter( 'vc_autocomplete_coures_tab_include_callback',	'vc_include_field_search', 10, 1 ); // Get suggestion(find). Must return an array
		add_filter( 'vc_autocomplete_coures_tab_include_render',
			'vc_include_field_render', 10, 1 ); // Render exact coure. Must return an array (label,value)

		// Narrow data taxonomies
		add_filter( 'vc_autocomplete_coures_tab_taxonomies_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
		add_filter( 'vc_autocomplete_coures_tab_taxonomies_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

		// Narrow data taxonomies for exclude_filter
		add_filter( 'vc_autocomplete_coures_tab_exclude_filter_callback', 'vc_autocomplete_taxonomies_field_search', 10, 1 );
		add_filter( 'vc_autocomplete_coures_tab_exclude_filter_render', 'vc_autocomplete_taxonomies_field_render', 10, 1 );

		add_filter( 'vc_autocomplete_coures_tab_exclude_callback',	'vc_exclude_field_search', 10, 1 ); // Get suggestion(find). Must return an array
		add_filter( 'vc_autocomplete_coures_tab_exclude_render', 'vc_exclude_field_render', 10, 1 ); // Render exact coure. Must return an array (label,value)
       // A must for container functionality, replace Wbc_Item with your base name from mapping for parent container
        if(class_exists('WPBakeryShortCodesContainer')){
            class WPBakeryShortCode_coures_tabs extends WPBakeryShortCodesContainer {
         
            }
        }
        // Replace Wbc_Inner_Item with your base name from mapping for nested element
        if(class_exists('WPBakeryShortCode')){
            class WPBakeryShortCode_coures_tab extends WPBakeryShortCode {
         
            }
        }