<?php
// testimonial
vc_map( array(
    'name' =>esc_html__( 'Testimonials', 'thebrilliance' ),
    'base' => 'jwstestimonials',
    "as_parent" => array('only' => 'jwstestimonial'),
    "content_element" => true,
    "show_settings_on_create" => false,
    'category' =>esc_html__( 'thebrilliance', 'thebrilliance' ),
    'description' =>esc_html__( 'User testimonials slider or grid', 'thebrilliance' ),

    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Layout', 'thebrilliance' ),
            'param_name' => 'layout',
            'value' => array(
               esc_html__( 'Slider', 'thebrilliance' ) => 'slider',
               esc_html__( 'Grid', 'thebrilliance' ) => 'grid',
            ),
        ),  

        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Columns', 'thebrilliance' ),
            'param_name' => 'columns',
            'value' => array(
                1,2,3,4
            ),
            'dependency' => array(
                'element' => 'layout',
                'value' => array( 'grid' ),
            ),
        ),

        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Slides per view', 'thebrilliance' ),
            'param_name' => 'slides_per_view',
            'value' => array(
                1,2,3,4
            ),
            'group' => 'Slider',
            'dependency' => array(
                'element' => 'layout',
                'value' => array( 'slider' ),
            ),
            'description' =>esc_html__( 'Set numbers of slides you want to display at the same time on slider\'s container for carousel mode.', 'thebrilliance' )
        ),

        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Nav Position', 'thebrilliance' ),
            'param_name' => 'nav_position',
            'group' => 'Slider',
            "value" => array(
                   esc_html__("Top", 'thebrilliance') => "top",
                   esc_html__("Left and Right", 'thebrilliance') => "lar",
                ),
            'std' => 'default',
        ),

        array(
            'type' => 'colorpicker',
            'heading' =>esc_html__( 'Text color', 'thebrilliance' ),
            'param_name' => 'text_color',
            'description' =>esc_html__( 'Select icon color.', 'thebrilliance' ),
            'value' => '#000',
        ),
        
        array(
            'type' => 'checkbox',
            'heading' =>esc_html__( 'Hide dots', 'thebrilliance' ),
            'param_name' => 'hide_dots',
            'description' =>esc_html__( 'If "YES" pagination control will be removed', 'thebrilliance' ),
            'value' => array(esc_html__( 'Yes, please', 'thebrilliance' ) => 'yes' ),
            'group' => 'Slider',
            'std' => 'yes',
        ),
        array(
            'type' => 'checkbox',
            'heading' =>esc_html__( 'Hide prev/next buttons', 'thebrilliance' ),
            'param_name' => 'hide_prev_next_buttons',
            'description' =>esc_html__( 'If "YES" prev/next control will be removed', 'thebrilliance' ),
            'value' => array(esc_html__( 'Yes, please', 'thebrilliance' ) => 'yes' ),
            'group' => 'Slider',
            'dependency' => array(
                'element' => 'layout',
                'value' => array( 'slider' ),
            ),
        ),
        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Extra class name', 'thebrilliance' ),
            'param_name' => 'el_class',
            'description' =>esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'thebrilliance' )
        ),
    ),
    "js_view" => 'VcColumnView'
)); 

vc_map( array(
    'name' =>esc_html__( 'Testimonial', 'thebrilliance' ),
    'base' => 'jwstestimonial',
    'class' => '',
    "as_child" => array('only' => 'jwstestimonials'),
    "content_element" => true,
    'category' =>esc_html__( 'thebrilliance', 'thebrilliance' ),
    'description' =>esc_html__( 'User testimonial', 'thebrilliance' ),
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Item Style', 'thebrilliance' ),
            'param_name' => 'item_style',
            "value" => array(
                   esc_html__("Default", 'thebrilliance') => "default",
                   esc_html__("Style 1", 'thebrilliance') => "style-1",
                ),
            'description' =>esc_html__( 'Style', 'thebrilliance' ),
            'std' => 'default',
        ),



        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Name', 'thebrilliance' ),
            'param_name' => 'name',
            'value' => 'Helene K',
            'description' =>esc_html__( 'User name', 'thebrilliance' )
        ),
        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Title', 'thebrilliance' ),
            'param_name' => 'title',
            'value' => 'Manage, New York',
            'description' =>esc_html__( 'User title', 'thebrilliance' )
        ),
        array(
            'type' => 'attach_image',
            'heading' =>esc_html__( 'User Avatar', 'thebrilliance' ),
            'param_name' => 'image',
            'value' => '',
            'description' =>esc_html__( 'Select image from media library.', 'thebrilliance' )
        ),

        array(
            'type' => 'attach_image',
            'heading' =>esc_html__( 'Quote Image', 'thebrilliance' ),
            'param_name' => 'quote_image',
            'value' => '',
            'description' =>esc_html__( 'Select image from media library.', 'thebrilliance' )
        ),

        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Image size', 'thebrilliance' ),
            'param_name' => 'img_size',
            'description' =>esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'thebrilliance' ),
            'value' => 'thumbnail',
        ),
        array(
            'type' => 'textarea_html',
            'holder' => 'div',
            'heading' =>esc_html__( 'Text', 'thebrilliance' ),
            'value' => "Nulla ut fringilla dui. Nullam sit amet pulvinar velit, at rutrum lacus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies placerat risus, nec mollis dui vulputate at. Maecenas vitae dolor massa. Ut lacus felis, suscipit ut diam quis.",
            'param_name' => 'content',
        ),
        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Extra class name', 'thebrilliance' ),
            'param_name' => 'el_class',
            'description' =>esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'thebrilliance' )
        )
    )
));
// A must for container functionality, replace Wbc_Item with your base name from mapping for parent container
if(class_exists('WPBakeryShortCodesContainer')){
    class WPBakeryShortCode_jwstestimonials extends WPBakeryShortCodesContainer {
 
    }
}
 
// Replace Wbc_Inner_Item with your base name from mapping for nested element
if(class_exists('WPBakeryShortCode')){
    class WPBakeryShortCode_jwstestimonial extends WPBakeryShortCode {
 
    }
}