<?php
/**
 * Template for displaying loop course review.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/addons/course-review/loop-review.php.
 *
 * @author ThimPress
 * @package LearnPress/Course-Review/Templates
 * version  3.0.1
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;
$arr_reviews = get_comment($review->comment_id);
?>

<li>

    <div class="review-author">
		<?php echo get_avatar( $review->user_email ) ?>
    </div>
    <div class="review-author-info">
        <h4 class="user-name">
			<?php do_action( 'learn_press_before_review_username' ); ?>
			<?php //echo $review->user_login; ?>
            <?php echo wp_kses_post($arr_reviews->comment_author); ?>
			<?php do_action( 'learn_press_after_review_username' ); ?>
        </h4>
		<?php learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $review->rate ) ); ?>

        <?php 
        // echo '<pre>';
        // $arr_reviews = get_comment($review->comment_id);
        printf('<i class="fa fa-calendar" aria-hidden="true"></i><span>%s %s</span>',
            esc_html__('Posted on','thebrilliance'),
            $arr_reviews->comment_date
        ); 
        // echo '<i class="fa fa-calendar" aria-hidden="true"></i>'.__('Posted on','thebrilliance').($arr_reviews->comment_date);
         // comment_date(); 
        // echo '</pre>';
         ?>
        <p class="review-title">
			<?php do_action( 'learn_press_before_review_title' ); ?>
            <?php echo wp_kses_post($review->title); ?>
			<?php do_action( 'learn_press_after_review_title' ); ?>
        </p>
    </div>
    <div class="review-text">
        <div class="review-content">
			<?php do_action( 'learn_press_before_review_content' ); ?>
            <?php echo wp_kses_post($arr_reviews->comment_content); ?>
			<?php //echo $review->content ?>
			<?php do_action( 'learn_press_after_review_content' ); ?>
        </div>
    </div>
</li>