<?php
/**
 * Template for displaying course content within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/content-single-course.php
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

if ( post_password_required() ) {
	echo get_the_password_form();
	return;
}
wp_enqueue_script( 'magnific-popup');
wp_enqueue_script( 'slick');
$course = LP()->global['course'];
$user   = learn_press_get_current_user();
$is_enrolled = $user->has_enrolled_course($course->get_id());

if (function_exists('fw_get_db_settings_option')) {
	$course_setting = fw_get_db_settings_option( 'course_settings' );
}else{
	$course_setting = array(
		'course_single_layout' => 'layout-1',
		'course_info' => 'yes',
	);
}
if (isset($_GET['layout'])) {
	$course_setting['course_single_layout'] = $_GET['layout'];
}


/**
 * @deprecated
 */
do_action( 'learn_press_before_main_content' );
do_action( 'learn_press_before_single_course' );
do_action( 'learn_press_before_single_course_summary' );

/**
 * @since 3.0.0
 */
do_action( 'learn-press/before-main-content' );

do_action( 'learn-press/before-single-course' );

?>
<div id="learn-press-course" class="course-summary course-<?php echo esc_attr($course_setting['course_single_layout']); ?>">
	<div class="row">

		<div class="col-lg-9 col-md-8 col-sm-7">
			<?php
			/**
			 * @since 3.0.0
			 *
			 * @see learn_press_single_course_summary()
			 */
			do_action( 'learn-press/single-course-summary' );
            if ($course_setting['course_single_layout'] == 'layout-2'): ?>
        	
        	
        	
        				<?php do_action( 'learn-press/jws-after-single-course-summary2' ); ?>
    
        
        	<?php else: ?>
        
        		<?php do_action( 'learn-press/jws-after-single-course-summary' ); ?>
        
        	<?php endif; ?>

		</div>
		
		<?php if ($course_setting['course_info'] == 'yes') : ?>
			<div class="col-lg-3 col-md-4 col-sm-5 sticky_sidebar">
				<div class="lp-tab-info">
					<?php 
					global $course;
				    learn_press_get_template( 'single-course/price.php' );
				    $max_students = get_post_meta( get_the_ID(), '_lp_max_students', true );
				    $schedule = get_post_meta( get_the_ID(), 'jws_course_schedule', true );
				    $difficulty = get_post_meta( get_the_ID(), 'jws_course_difficulty', true );
				    $branch = get_post_meta( get_the_ID(), 'jws_course_branch', true );
				    $typology = get_post_meta( get_the_ID(), 'jws_course_typology', true );
				    $language = get_post_meta( get_the_ID(), 'jws_course_language', true );
				    ?>
					<ul class="lp-info-course">
						<li>
							<span class="jws-label"><?php esc_html_e('Available Seats','thebrilliance'); ?> </span>
							<span class="jws-value"><?php echo wp_kses_post($max_students); ?> </span>
						</li>
						<li>
							<span class="jws-label"><?php esc_html_e('Schedule','thebrilliance'); ?> </span>
							<span class="jws-value"><?php echo wp_kses_post($schedule); ?> </span>
						</li>
						<li>
							<span class="jws-label"><?php esc_html_e('Difficulty Level','thebrilliance'); ?> </span>
							<span class="jws-value"><?php echo wp_kses_post($difficulty); ?> </span>
						</li>
						<li>
							<span class="jws-label"><?php esc_html_e('Branch','thebrilliance'); ?> </span>
							<span class="jws-value"><?php echo wp_kses_post($branch); ?> </span>
						</li>
						<li>
							<span class="jws-label"><?php esc_html_e('Typology','thebrilliance'); ?> </span>
							<span class="jws-value"><?php echo wp_kses_post($typology); ?> </span>
						</li>
						<li>
							<span class="jws-label"><?php esc_html_e('Lecture','thebrilliance'); ?> </span>
							<span class="jws-value"><?php echo wp_kses_post($course->count_items()); ?> </span>
						</li>
						<li>
							<span class="jws-label"><?php esc_html_e('Language','thebrilliance'); ?> </span>
							<span class="jws-value"><?php echo wp_kses_post($language); ?> </span>
						</li>
						<li>
							<span class="jws-label"><?php esc_html_e('Student Enrolled','thebrilliance'); ?> </span>
							<span class="jws-value"><?php echo wp_kses_post($course->get_users_enrolled()); ?> </span>
						</li>
					</ul>
                
					<?php  if ( !$is_enrolled ) { learn_press_course_buttons();} ?>
				</div>
			</div>
		<?php endif; ?>

	</div>




</div>
<?php jws_related_courses(); ?>
<?php

/**
 * @since 3.0.0
 */
do_action( 'learn-press/after-main-content' );

do_action( 'learn-press/after-single-course' );

/**
 * @deprecated
 */
do_action( 'learn_press_after_single_course_summary' );
do_action( 'learn_press_after_single_course' );
do_action( 'learn_press_after_main_content' );