<?php
/**
 * Template for displaying pagination of course within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/loop/course/pagination.php.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $wp_query;

if ( $wp_query->max_num_pages <= 1 ) {
	return;
}
	$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	if ( function_exists( 'fw_get_db_settings_option' ) ){
		$course_settings = fw_get_db_settings_option('course_settings');
	}else{
		$course_settings = array(
			'archive_course_pagination' => 'numeric',
		);
	}

	if(isset($_GET['layout'])){ 
		$course_settings['archive_course_layout'] = $_GET['layout']; 
	}

	if($course_settings['archive_course_pagination'] == 'loadmore'){
		$encoded_atts = json_encode( $course_settings );
		$loadmore = '<nav class="navigation paging-navigation" role="navigation">
			<a href="#" class="course-loadmore jws-load-more" data-atts="'.esc_attr($encoded_atts).'" data-paged="'.esc_attr($paged).'">'.esc_html__('Load More','thebrilliance').'</a>
			<p class="posts-loaded">'.esc_html__('All items Loaded','thebrilliance').'</p>
		</nav>';
		echo wp_kses_post($loadmore);
	}else{
	    $args = array( 
	        'prev_next'    => false,
	    );
	    $number_link = paginate_links( $args );
	    $previous 	= get_previous_posts_link( '<span class="prev">'.esc_html__('Previous','thebrilliance').'</span>' );
	    $next 		= get_next_posts_link( '<span class="next">'.esc_html__('Next','thebrilliance').'</span>'); 
		$link 		= '<nav class="navigation paging-navigation" role="navigation"><div class="pagination loop-pagination">'.$previous . $next . $number_link.'</div></nav>';
	    echo wp_kses_post($link);
    }
?>
