<?php
/**
 * Template for displaying Dashboard of user profile.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/profile/dashboard.php.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();
$profile = LP_Global::profile();
$user    = $profile->get_user();
$after_sc  = get_the_author_meta('shortcode2',$user->get_id());
$description = get_the_author_meta('description',$user->get_id());
?>

<div class="learn-press-profile-dashboard">

	<?php
	/**
	 * Before dashboard
	 */
     
     
	do_action( 'learn-press/profile/before-dashboard' );

	if ($after_sc != '' && function_exists('jws_execution_shortcode')) {
		echo jws_execution_shortcode($after_sc);
	}elseif(!empty($description)) {
	   echo esc_html($description);
	}else {
	   echo esc_html__('You have not added Profile information for your account. Please add content for your account at the settings tab','thebrilliance');
	}


	/**
	 * After dashboard
	 */
	do_action( 'learn-press/profile/after-dashboard' );

	?>

</div>