<?php
/**
 * Template for displaying main user profile page.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/profile/profile.php.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$profile = LP_Global::profile();
$user    = $profile->get_user();
$twitter = get_the_author_meta('twitter',$user->get_id());
$facebook = get_the_author_meta('facebook',$user->get_id());
$instagram = get_the_author_meta('instagram',$user->get_id());
$google = get_the_author_meta('gplus',$user->get_id());
$instructor_type = get_the_author_meta('instructor_type',$user->get_id());
$name = get_the_author_meta('display_name',$user->get_id());
$description = get_the_author_meta('description',$user->get_id());


$before_sc  = get_the_author_meta('shortcode1',$user->get_id());

echo '<div class="jws-wrap-profile">';
wp_enqueue_script( 'magnific-popup');
	if ( $profile->is_public()) {
		?>
        <div class="row row_flex_lp">
            <div class="col-lg-6 col-md-6 col-sm-6">
                  
            <div class="in_info">
        <h4 class="in_name">
         <?php echo esc_html($name);?>
            </h4>
            <p class="in_job">
                <?php echo esc_html($instructor_type);   ?>
            </p> 
            <?php 	if ($description != '') {
		echo esc_html($description);
	} ?>
           <ul class="social_author_list">
           <?php if(!empty($facebook)) : ?>
            <li><a href="<?php echo esc_url($facebook); ?>" class="in_facebook" href=""><span class="icon-facebook"></span></a></li>
           <?php endif; ?>
           <?php if(!empty($twitter)) : ?>
            <li><a href="<?php echo esc_url($twitter); ?>" class="in_twitter" href=""><span class="icon-twitter"></span></a></li>
           <?php endif; ?>
           <?php if(!empty($instagram)) : ?>
            <li><a href="<?php echo esc_url($instagram); ?>" class="in_instagram" href=""><span class="icon-instagram"></span></a></li>
           <?php endif; ?>
           <?php if(!empty($google)) : ?>
            <li><a href="<?php echo esc_url($google); ?>" class="in_google" href=""><span class="icon-google-plus"></span></a></li>
           <?php endif; ?>
        </ul>
        </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6">
                       <div class="author-avatar"><?php echo get_avatar($user->get_id(),500); ?></div>
            </div>
        </div>
   

	            <div id="learn-press-user-profile"<?php $profile->main_class(); ?>>

			<?php


			/**
			 * @since 3.0.0
			 */
			do_action( 'learn-press/before-user-profile', $profile );

			/**
			 * @since 3.0.0
			 */
			do_action( 'learn-press/user-profile', $profile );

			/**
			 * @since 3.0.0
			 */
			do_action( 'learn-press/after-user-profile', $profile );

			?>

	    </div>

	<?php } else {
		_e( 'This user does not public their profile.', 'thebrilliance' );
	}


echo '</div>';
