<?php
/**
 * Template for displaying price of single course.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/single-course/price.php.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$user   = LP_Global::user();
$course = LP_Global::course();

if ( ! $price = $course->get_price_html() ) {
	return;
}
?>

<div class="course-price">
	<div class="sale-price">
		<h4><?php esc_html_e('Price','thebrilliance'); ?></h4>
		<span class="price"><?php echo wp_kses_post($price); ?></span>
	</div>
	
	<?php if ( $course->has_sale_price() ) { ?>
		<div class="origin-price">
        	<span class="price"><?php echo wp_kses_post($course->get_origin_price_html()); ?></span>
        	<?php $sale_promote = get_post_meta( get_the_ID(), 'jws_course_sale_promote', true ); ?>
        	<span class="sale-promote"><?php echo wp_kses_post($sale_promote); ?></span>
		</div>
	<?php } ?>
</div>