<?php
/**
 * The Template for displaying all single posts
 */

global $sidebar;
$sidebar = 'blog-widget';
$class = 'col-md-12';
if (is_active_sidebar( $sidebar )) {
	$class = 'col-lg-9 col-md-8';
}
wp_enqueue_script( 'slick');
if (defined( 'FW' )) {
	$post_setting = fw_get_db_settings_option('posts_settings');
}else{
	$post_setting = array(
		'related_articles' => 'no',
		'related_columns' => 3,
		'related_style' => 'grid',
	);
}
get_header(); 
?>
	<div class="main-content blog-single">
		<div class="container">
			<div class="row">
				<div id="primary" class="<?php echo esc_attr($class); ?>">
					<div id="content" class="site-content" role="main">
						<?php
							// Start the Loop.
							while ( have_posts() ) : the_post();

								/*
								 * Include the post format-specific template for the content. If you want to
								 * use this in a child theme, then include a file called called content-___.php
								 * (where ___ is the post format) and that will be used instead.
								 */
								get_template_part( 'content', 'single' );

								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) {
									comments_template();
								}

								if ($post_setting['related_articles'] == 'yes'){
									jws_related_post($post_setting);
								} 

							endwhile;
						?>
					</div><!-- #content -->
				</div>
				<?php get_sidebar(); ?>
			</div>
		</div>
	</div>
		
<?php get_footer(); ?>