<?php
/**
 * Month View Nav Template
 * This file loads the month view navigation.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/month/nav.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.19
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
} ?>

<?php do_action( 'tribe_events_before_nav' ) ?>

<nav class="tribe-events-nav-pagination" aria-label="<?php esc_html_e( 'Calendar Month Navigation', 'thebrilliance' ) ?>">
	<div class="tribe-events-sub-nav">
		<div class="tribe-events-nav-previous">
			<?php tribe_events_the_previous_month_link2(); ?>
		</div>


		<div class="tribe-events-title-bar">
			<!-- Month Title -->
			<?php do_action( 'tribe_events_before_the_title' ); ?>
			<h1 class="tribe-events-page-title"><?php echo tribe_get_events_title2() ?></h1>
			<?php do_action( 'tribe_events_after_the_title' ); ?>
		</div>



		<!-- .tribe-events-nav-previous -->
		<div class="tribe-events-nav-next">
			<?php tribe_events_the_next_month_link2(); ?>
		</div>
		<!-- .tribe-events-nav-next -->
	</div><!-- .tribe-events-sub-nav -->
</nav>
<?php
do_action( 'tribe_events_after_nav' );
